
tcgaClinical<-read.table("tcgaClinical.txt",sep="\t",check.names=F,header=T,row.names=1)   
tcgaRisk<-read.table("tcgaRisk.txt",sep="\t",check.names=F,header=T,row.names=1)   

TCGA<-merge(tcgaRisk, tcgaClinical, by="row.names", all = F) 

library(rmda)


riskScore<- decision_curve(fustat.y~riskScore,data= TCGA,
                        family = binomial(link ='logit'),
                        thresholds= seq(0,1, by = 0.01),
                        confidence.intervals = 0.95,
                        study.design = 'case-control',
                        population.prevalence = 0.3)

age<-decision_curve(fustat.y~age,
                        data = TCGA,family = binomial(link ='logit'),
                        thresholds = seq(0,1, by = 0.01),
                        confidence.intervals= 0.95,
                        study.design = 'case-control',
                        population.prevalence= 0.3)

gender<-decision_curve(fustat.y~gender,
                    data = TCGA,family = binomial(link ='logit'),
                    thresholds = seq(0,1, by = 0.01),
                    confidence.intervals= 0.95,
                    study.design = 'case-control',
                    population.prevalence= 0.3)

stage<-decision_curve(fustat.y~stage,
                       data = TCGA,family = binomial(link ='logit'),
                       thresholds = seq(0,1, by = 0.01),
                       confidence.intervals= 0.95,
                       study.design = 'case-control',
                       population.prevalence= 0.3)


List<- list(riskScore,age,gender,stage)

plot_decision_curve(List,
                    curve.names=c('riskScore','age','gender','stage'),
                    cost.benefit.axis =FALSE,col= c('red','blue','purple','green'),
                    confidence.intervals=FALSE,
                    standardize = FALSE)



geoClinical<-read.table("geoClinical.txt",sep="\t",check.names=F,header=T,row.names=1)   
geoRisk<-read.table("geoRisk.txt",sep="\t",check.names=F,header=T,row.names=1)   

GEO<-merge(geoRisk, geoClinical, by="row.names", all = F) 


riskScore<- decision_curve(fustat.x~riskScore,data= GEO,
                           family = binomial(link ='logit'),
                           thresholds= seq(0,1, by = 0.01),
                           confidence.intervals = 0.95,
                           study.design = 'case-control',
                           population.prevalence = 0.3)

age<-decision_curve(fustat.x~Age,
                    data = GEO,family = binomial(link ='logit'),
                    thresholds = seq(0,1, by = 0.01),
                    confidence.intervals= 0.95,
                    study.design = 'case-control',
                    population.prevalence= 0.3)

gender<-decision_curve(fustat.x~Gender,
                       data = GEO,family = binomial(link ='logit'),
                       thresholds = seq(0,1, by = 0.01),
                       confidence.intervals= 0.95,
                       study.design = 'case-control',
                       population.prevalence= 0.3)

Cirrhosis<-decision_curve (fustat.x~Cirrhosis,
                      data = GEO,family = binomial(link ='logit'),
                      thresholds = seq(0,1, by = 0.01),
                      confidence.intervals= 0.95,
                      study.design = 'case-control',
                      population.prevalence= 0.3)


TNMstaging<-decision_curve (fustat.x~TNMstaging,
                           data = GEO,family = binomial(link ='logit'),
                           thresholds = seq(0,1, by = 0.01),
                           confidence.intervals= 0.95,
                           study.design = 'case-control',
                           population.prevalence= 0.3)


BCLCstaging<-decision_curve (fustat.x~BCLCstaging,
                            data = GEO,family = binomial(link ='logit'),
                            thresholds = seq(0,1, by = 0.01),
                            confidence.intervals= 0.95,
                            study.design = 'case-control',
                            population.prevalence= 0.3)


List<- list(riskScore,age,gender,Cirrhosis,TNMstaging,BCLCstaging)

plot_decision_curve(List,
                    curve.names=c('riskScore','age','gender','Cirrhosis','TNMstaging','BCLCstaging'),
                    cost.benefit.axis =FALSE,col= c('red','blue','purple','green','yellow','orange'),
                    confidence.intervals=FALSE,
                    standardize = FALSE)
